package fr.asip.cps3.exemple.controleurs;

import fr.asip.cps3.exemple.modele.ecouteurs.ApplicationEcouteur;

/**
 *  Classe abstraite reprsentant une vue de l'application
 *
 */
public abstract class ApplicationVue implements ApplicationEcouteur{
	
	/**
	 * Contrleur de la fentre principale
	 */
	private ApplicationControleur controleur = null;
	
	/**
	 * Constructeur
	 * @param controleur de la fentre principale
	 */
	public ApplicationVue(ApplicationControleur controleur) {
		super();
		this.controleur = controleur;
	}
	
	/**
	 * Accesseur
	 * @return Le contrleur de la fentre principale
	 */
	public final ApplicationControleur getControlleur(){
		return controleur;
	}
	
	/**
	 * Affichage de la fentre
	 */
	public abstract void affiche();
	
	/**
	 * Fermeture de la fentre
	 */
	public abstract void ferme();
	
}
